' * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
' Electronic switch for RC-Powersystems
' copyright by flightronic.com 2006/2007
' ' * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

'********** Configuration Settings **********
$regfile = "attiny13.dat"                                                       ' use ATTiny13V definitions
$crystal = 600000                                                               ' Set 4.8 MHz Clock, Divider = 8
$hwstack = 16
$swstack = 16
$framesize = 16

Const True = 1
Const False = 0
Const Aus = 0
Const Ein = 1
Const Btn_on = 0
Const Btn_off = 1
Const Channel = 2
Const Vok = 0
Const Vwarn = 1
Const Valert = 2

$eeprom
Data &h06                                                                       ' Version
Data &h00                                                                       ' PowerMode
Data &hEF , &h1                                                                 ' Warn level ~4.7V
Data &hC7 , &h1                                                                 ' Alert level ~4.4V
Data &h97 , &h1                                                                 ' Shutdown level ~4.0V
Data &h00 , &h00                                                                ' adcCnt (debug only)
$data

Dim DataDummy as Eram Byte                                                      ' Do not use Byte 0 in EEPROM
Dim PwrStatus as Eram Byte                                                      ' EEPROM copy PwrStatus
Dim WarnVadc as Eram Word                                                       ' minimal ADC count for warn voltage detection
Dim AlertVadc as Eram Word                                                      ' minimal ADC count for alert voltage detection
Dim ShutdownVadc as Eram Word                                                   ' minimal ADC count for shutdown system
Dim adcCnt as Eram Word

Dim adcCount as Word
Dim bufBtn as Word
Dim i as Integer

outGreenLED Alias PortB.0
inBtn Alias PinB.1
outRedLED Alias PortB.2
outPwr Alias PortB.3
DDRB = Bits(0 , 2 , 3)                                                        ' Data direction for PortB
PortB = Bits(1)

Config Watchdog = 4096
Start Watchdog

' ADC
Config Adc = Single , Prescaler = auto , Reference = Internal
Start Adc
adcCount = Getadc(Channel)

If PwrStatus = Aus Then
  ' Watchdog startup
  If MCUSR.3 = True Then
    MCUSR.3 = False
    Reset outPwr
    Reset outGreenLED
    adcCount = Getadc(Channel)
    'adcCnt = adcCount
    Select Case adcCount
      Case Is < AlertVadc
        Set outRedLED
        WaitMs 50
        Reset outRedLED
        WaitMs 200
        Set outRedLED
        WaitMs 50
        Reset outRedLED
      Case Is < WarnVadc
        Set outRedLED
        WaitMs 50
        Reset outRedLED
      Case Else
        Set outGreenLED
        WaitMs 50
        Reset outGreenLED
    End Select
    Goto Sleep

  'INT0 startup
  Else
    MCUSR.1 = False
    Disable Interrupts
    Waitms 500
    If inBtn = Btn_off then
      Goto Sleep
    Else
      Goto SwitchOn
    End If
  End If
End if

SwitchOn:
Config Adc = Single , Prescaler = 128 , Reference = Internal
Start Adc
adcCount = Getadc(Channel)
bufBtn = &H0000
PwrStatus = Ein

Disable INT0
Disable Interrupts
Do
  Reset Watchdog
  Set outPwr
  Set outGreenLED
  adcCount = Getadc(Channel)
  Select Case adcCount
    Case Is < AlertVadc
      Set outRedLED
    Case Is < WarnVadc
      Toggle outRedLED
    Case Else
      Reset outRedLED
  End Select

  Shift bufBtn , Left
  bufBtn.0 = Not inBtn
  If bufBtn = &B0000000000111111 Then
    For i = 1 to 20
      Toggle outGreenLED
      Reset Watchdog
      Waitms 50
    Next i
    If inBtn = Btn_off Then
      For i = 1 to 15
        Toggle outGreenLED
        Reset Watchdog
        Waitms 100
        If inBtn = Btn_on Then Exit For
      Next i
      If inBtn = Btn_on Then
        PwrStatus = Aus
        Reset outPwr
        Reset outGreenLED
        Reset outRedLED
        Do
          Reset Watchdog
        Loop Until inBtn = Btn_off
        Config Watchdog = 256
        Start Watchdog
        Goto Sleep
      End If
    End If
  End If
  WaitMs 250
Loop

Sleep:
  Stop Adc
  Config INT0 = LOW LEVEL                                                       ' Set Low level detection for INT0
  Enable INT0
  Enable Interrupts
  Powerdown
  $asm
    jmp &H0000
  $end asm
End